//=============================================================================
// rocket.
//=============================================================================
class DC_Rocket extends Projectile;

var bool    launched;
var byte    RocketIndex;
var Actor   Seeking;
var Emitter SmokeTrail;
var float   LaunchedTime, LastDistToEnemy;

simulated function Launch()
{
 Velocity = vector(Rotation)*1000;
 AmbientSound = Sound'WeaponSounds.RocketLauncher.RocketLauncherProjectile';
 AmbientGlow = 64;
 LightRadius=7;
 SetTimer(0.1, true);
 Speed=MaxSpeed;
 launched = true;
 LaunchedTime = Level.TimeSeconds + 0.1;
 if (Seeking != none)
  LastDistToEnemy = VSize(Seeking.Location - Location);

 if (Level.NetMode != NM_DedicatedServer)
  {
   Spawn(class'Launch_flash',,,Location, Rotation);
   PlaySound(Sound'WeaponSounds.Misc.redeemer_shoot',,32);
   SmokeTrail = Spawn(class'DC_Rocket_Trail',,,Location, Rotation);
   SmokeTrail.Setbase(self);
  }
}

simulated function Timer()
{
 local vector ForceDir;

 if ( (Seeking != None) && (Seeking != Instigator) && (LaunchedTime < Level.TimeSeconds))
  {
   ForceDir = Normal(Seeking.Location - Location);
   Acceleration = ForceDir*100000;
  }
 else
  {
   Acceleration = vector(Rotation)*100000;
  }

 SetRotation(rotator(Acceleration));

 if ((Seeking != none) && (LaunchedTime < Level.TimeSeconds))
  {
   if (VSize(Seeking.Location - Location) < LastDistToEnemy)
    LastDistToEnemy = VSize(Seeking.Location - Location);
   else
    Explode(Location, vector(Rotation));
  }
}

simulated function Landed( vector HitNormal )
{
 if (launched == true)
  Explode(Location,HitNormal);
}

simulated function ProcessTouch (Actor Other, Vector HitLocation)
{
 if ( (launched == true) && (Other != instigator) && (!Other.IsA('Projectile') || Other.bProjTarget) )
  Explode(HitLocation, vector(rotation)*-1 );
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
 if(launched == true)
  {
   PlaySound(sound'WeaponSounds.BExplosion3',,255);
   if (!bNoFX && EffectIsRelevant(Location, false))
    Spawn(class'ONSAVRiLRocketExplosion',,, Location, rotator(vect(0,0,1)));
   HurtRadius(Damage, DamageRadius, MyDamageType, MomentumTransfer, HitLocation );
   if (Owner != None)
    Owner.PlaySound(sound'WeaponSounds.BExplosion3', SLOT_Interact, 0.1,, TransientSoundRadius);
   MakeNoise(1.0);
   Destroy();
  }
}

simulated function Destroyed()
{
 if ( SmokeTrail != None )
  SmokeTrail.Kill();
 if (DC_Walker(Owner) != none)
  DC_Walker(Owner).Rocket_Sensor[RocketIndex] = 0;

 Super.Destroyed();
}

defaultproperties
{
 Speed=0
 MaxSpeed=10000
 Damage=300
 DamageRadius=500
 MomentumTransfer=50000
 MyDamageType=Class'XWeapons.DamTypeRocket'
 ExplosionDecal=Class'XEffects.RocketMark'
 LightType=LT_Steady
 LightEffect=LE_QuadraticNonIncidence
 LightHue=28
 LightBrightness=255.000000
 LightRadius=0
 DrawType=DT_StaticMesh
 StaticMesh=StaticMesh'DC_Walker_C.Missle'
 CullDistance=8000.000000
 bDynamicLight=True
 LifeSpan=0
 DrawScale=1.5
 AmbientGlow=0
 FluidSurfaceShootStrengthMod=10.000000
 SoundVolume=16
 SoundRadius=1
 ForceType=FT_Constant
 ForceRadius=100.000000
 ForceScale=5.000000
 RemoteRole=ROLE_None
}
