class SonicRPGStatsInv extends RPGStatsInv;

simulated function AdjustMaxAmmo()
{
	local Inventory Inv;
	local Ammunition Ammo;
	local int Count;
	local float Modifier;

	Modifier = 1.0 + float(Data.AmmoMax) * 0.01;
	for (Inv = Instigator.Inventory; Inv != None; Inv = Inv.Inventory)
	{
		Ammo = Ammunition(Inv);
		if (Ammo != None)
		{
			if (!class'MutUT2004RPG'.static.IsSuperWeaponAmmo(Ammo.Class))
			{
				Ammo.MaxAmmo = Ammo.default.MaxAmmo * Modifier;
                Ammo.InitialAmount = Ammo.default.InitialAmount * Modifier;
			}
			else Ammo.MaxAmmo = Min(Ammo.default.MaxAmmo * Modifier, 20);
			if (Ammo.AmmoAmount > Ammo.MaxAmmo)
				Ammo.AmmoAmount = Ammo.MaxAmmo;
		}
		Count++;
		if (Count > 1000)
			break;
	}
}
