//-----------------------------------------------------------
//  Game Logger Chat Hook
//-----------------------------------------------------------
//  by Michael "_Lynx" Sokolkov  2004
//-----------------------------------------------------------
class MessageLogHandler extends BroadcastHandler;

var EGameStats MyStatsActor;
var string tempCommonString, tempTeamSayString, tempOtherString;
var bool bIsInitialized;

function PostBeginPlay(){
         Super.PostBeginPlay();

}

function BroadcastText( PlayerReplicationInfo SenderPRI, PlayerController Receiver, coerce string Msg, optional name Type )
{
  if ( !AcceptBroadcastText(Receiver, SenderPRI, Msg, Type) )
    return;
    if (tempOtherString != Msg && (Type != 'GameLoggerStatus')){ //Preventing 4x repeat spam which was found during the test runs.
      MyStatsActor.LogMessage(SenderPRI, Msg, Type);
      tempOtherString = Msg;
    }


  if ( NextBroadcastHandler != None ){
    NextBroadcastHandler.BroadcastText( SenderPRI, Receiver, Msg, Type );
  }
  else Receiver.TeamMessage( SenderPRI, Msg, Type );

}

function Broadcast( Actor Sender, coerce string Msg, optional name Type )
{
  local Controller C;
  local PlayerController P;
  local PlayerReplicationInfo PRI;

  // see if allowed (limit to prevent spamming)
  if ( !AllowsBroadcast(Sender, Len(Msg)) )
    return;

  if ( Pawn(Sender) != None )
    PRI = Pawn(Sender).PlayerReplicationInfo;
  else if ( Controller(Sender) != None )
    PRI = Controller(Sender).PlayerReplicationInfo;

  if ( bPartitionSpectators && !Level.Game.bGameEnded && (PRI != None) && !PRI.bAdmin && (PRI.bOnlySpectator || PRI.bOutOfLives) )
  {
    For ( C=Level.ControllerList; C!=None; C=C.NextController )
    {
      P = PlayerController(C);
      if ( (P != None) && (P.PlayerReplicationInfo.bOnlySpectator || P.PlayerReplicationInfo.bOutOfLives) )
        if (tempCommonString != Msg){  //Preventing 4x repeat spam and the string about the log being saved .
          BroadcastText(PRI, P, Msg, Type);
          tempCommonString = Msg;
        }
    }
  }
  else
  {
    For ( C=Level.ControllerList; C!=None; C=C.NextController )
    {
      P = PlayerController(C);
      if ( P != None )
        if (tempCommonString != Msg){ //Preventing 4x repeat spam which was found during the test runs.
          BroadcastText(PRI, P, Msg, Type);
          tempCommonString = Msg;
        }
    }
  }

  MyStatsActor.LogMessage(PRI, Msg, Type);
}

function BroadcastTeam( Controller Sender, coerce string Msg, optional name Type )
{
  local Controller C;
  local PlayerController P;

  // see if allowed (limit to prevent spamming)
  if ( !AllowsBroadcast(Sender, Len(Msg)) )
    return;

  if ( bPartitionSpectators && !Level.Game.bGameEnded && (Sender != None) && !Sender.PlayerReplicationInfo.bAdmin && (Sender.PlayerReplicationInfo.bOnlySpectator || Sender.PlayerReplicationInfo.bOutOfLives) )
  {
    For ( C=Level.ControllerList; C!=None; C=C.NextController )
    {
      P = PlayerController(C);
      if ( (P != None) && (P.PlayerReplicationInfo.Team == Sender.PlayerReplicationInfo.Team)
        && (P.PlayerReplicationInfo.bOnlySpectator || P.PlayerReplicationInfo.bOutOfLives) ){
          if (tempTeamSayString != Msg){ //Preventing 4x repeat spam which was found during the test runs.
            BroadcastText(Sender.PlayerReplicationInfo, P, Msg, Type);
            tempTeamSayString = Msg;
        }
      }
    }
  }
  else
  {
    For ( C=Level.ControllerList; C!=None; C=C.NextController )
    {
      P = PlayerController(C);
      if ( (P != None) && (P.PlayerReplicationInfo.Team == Sender.PlayerReplicationInfo.Team) && (tempTeamSayString != Msg)){
        if (tempTeamSayString != Msg){ //Preventing 4x repeat spam which was found during the test runs.
          BroadcastText(Sender.PlayerReplicationInfo, P, Msg, Type);
          tempTeamSayString = Msg;
        }
      }
    }
  }

  MyStatsActor.LogMessage(Sender.PlayerReplicationInfo, Msg, Type);
}

defaultproperties
{
}
