//-----------------------------------------------------------
//  Game Logger Game Rules
//-----------------------------------------------------------
//  by Michael "_Lynx" Sokolkov  2004
//-----------------------------------------------------------
class GameLoggerRules extends GameRules config(GameLogger);

var EGameStats MyStats; //assigned by mutator
var bool bIsInitialized;
var config bool bDebug;
var globalconfig int DamageThreshold;
var int TrueDamageThreshold;

function PostBeginPlay(){
  Super.PostBeginPlay();

  MyStats = EGameStats(Level.Game.GameStats);

  if (DamageThreshold == 0)
    TrueDamageThreshold = 64;
  else if (DamageThreshold == 1)
    TrueDamageThreshold = 69;
  else if (DamageThreshold == 2)
    TrueDamageThreshold = 74;     // default value
  else if (DamageThreshold == 3)
    TrueDamageThreshold = 79;
  else if (DamageThreshold == 4)
    TrueDamageThreshold = 84;
  else if (DamageThreshold == 5)
    TrueDamageThreshold = 89;
  else
    TrueDamageThreshold = 74;     // fool proof;
}

function bool OverridePickupQuery(Pawn Other, Pickup item, out byte bAllowPickup)
{
  MyStats.PickupEvent(Other, item);

  if ( (NextGameRules != None) &&  NextGameRules.OverridePickupQuery(Other, item, bAllowPickup) )
    return true;
  return false;
}

function int NetDamage( int OriginalDamage, int Damage, pawn injured, pawn instigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType )
{
  local bool bContinue;

  local int healthwillleft;
  local int i;

	bContinue=True;

  if (MyStats.HeavyDamageReportMode == 0) 			// logging is disabled
    bContinue=False;

  healthwillleft = (injured.Health - Damage); 	// Damage absorbing by armor is already applied to Damage before calling NetDamage
																								// Check Engine.Gameinfo, lines #1780 - 1786

  if ( (MyStats.HeavyDamageReportMode == 1) && (healthwillleft <= 0) ) // log only if vicim survived
    bContinue=False;

  For (i = 0; i < MyStats.DamageTypePlugins.Length; i++){
  	if (MyStats.DamageTypePlugins[i].DontHDThisDamage(damagetype))
  		bContinue=False;
  }

  if(damagetype == class'Burned')																{bContinue=false;}
  else if(damagetype == class'Corroded')												{bContinue=false;}
  else if(damagetype == class'Crushed')													{bContinue=false;}
  else if(damagetype == class'Drowned')													{bContinue=false;}
  else if(damagetype == class'fell')														{bContinue=false;}
  else if(damagetype == class'Burned')													{bContinue=false;}
  else if(damagetype == class'DamTypeAttackCraftRoadkill')			{bContinue=false;}
  else if(damagetype == class'DamTypeHoverBikeHeadshot')				{bContinue=false;}
  else if(damagetype == class'DamTypeIonTankRoadkill')					{bContinue=false;}
  else if(damagetype == class'DamTypeMASRoadkill')							{bContinue=false;}
  else if(damagetype == class'DamTypeAttackCraftPancake')				{bContinue=false;}
  else if(damagetype == class'DamTypeHoverBikePancake')					{bContinue=false;}
  else if(damagetype == class'DamTypeIonTankPancake')						{bContinue=false;}
  else if(damagetype == class'DamTypeMASPancake')								{bContinue=false;}
  else if(damagetype == class'DamTypePRVPancake')								{bContinue=false;}
  else if(damagetype == class'DamTypeRVPancake')								{bContinue=false;}
  else if(damagetype == class'DamTypeTankPancake')							{bContinue=false;}
  else if(damagetype == class'DamTypePRVRoadkill')							{bContinue=false;}
  else if(damagetype == class'DamTypeRVRoadkill')								{bContinue=false;}
  else if(damagetype == class'DamTypeDestroyedVehicleRoadKill')	{bContinue=false;}
  else if(damagetype == class'DamTypeTankRoadkill')							{bContinue=false;}
  else if(damagetype == class'DamTypeONSVehicleExplosion')			{bContinue=false;}
  else if(damagetype == class'DamTypeONSVehicle')								{bContinue=false;}
  else if(damagetype == class'DamTypeIonBlast')									{bContinue=false;}
  else if(damagetype == class'DamTypeTelefragged')							{bContinue=false;}
  else if(damagetype == class'DamTypeONSRVBlade')								{bContinue=false;}
  else if(damagetype == class'DamTypeONSWeb')										{bContinue=false;}
  else if(damagetype == class'DamTypeIonTankBlast')							{bContinue=false;}
  else if(damagetype == class'DamTypeIonCannonBlast')						{bContinue=false;}
  else if(damagetype == class'DamTypeMASCannon')								{bContinue=false;}
  else if(damagetype == class'DamTypeTankShell')								{bContinue=false;}
  if (bDebug){
    if (MyStats == None){              Log("Stats Rules: Shit! My stats is not assigned!");                                          }
    if (!MyStats.bReportHeavyDamage){  Log("Stats Rules: Report Heavy Damage is off");                                               }
    if (!bContinue){                   Log("Stats Rules: some of the 'instadeath' damagetype used, stopping");                       }
    if (Damage < TrueDamageThreshold){ Log("Stats Rules: Damage is"@damage@"which is lower then "$TrueDamageThreshold$". Stopping"); }
  }
	if (MyStats != None && bContinue && Damage > TrueDamageThreshold)
    MyStats.HDamageEvent(injured, instigatedby, damage, damagetype);

  if ( NextGameRules != None )
    return NextGameRules.NetDamage( OriginalDamage,Damage,injured,instigatedBy,HitLocation,Momentum,DamageType );

  return Damage;
}

defaultproperties
{
 bDebug=False
}
