//-----------------------------------------------------------
//  Game Logger HTML wrapper
//-----------------------------------------------------------
//  This class will allow modifying HTML apperarance of the
// log without making changing to the main module
// This one will be a default wrapper class, but you may make
// your own, by subclassing it and changing the config
// variable myHTMLwrapper in EGameStats
//-----------------------------------------------------------
//  by Michael "_Lynx" Sokolkov  2004-2005
//
//-----------------------------------------------------------
class GameLoggerHTMLwrapper extends Info
 config(GameLogger);

var EGameStats BaseLogger;

struct BGColors{                                   // This struct keeps info about background color
  var() config string ColorHex;                    // That's the hex value of the color, f.e. #000000 is black, #ffffff is white
  var() config bool bInvert;                       // This is set to true if the background is dark. This tells the wrapper that
                                                   // it should use the white color for the text;
};

var() globalconfig array<BGColors> BGColorsArray;  // array of background colors
var   globalconfig int BGColor;                    // # of string in array containing current bg color
var   globalconfig bool brandomBGcolor;            // If the log will select a random BG color for each match
var   globalconfig bool bUseGraphics;              // will there be images in the log
var() string imagessubfolder;                      // name of the folder to put images for your skin;
                                                   // to keep the things organized;

var string ColoredBlueTeamName;                    // That's a performance var. The wrapper will save the colored version of
var string ColoredRedTeamName;                     // team name here and the logger will take them from here, rather than excuting CTName each time.

var localized string DMMutName,
                     DMMutDesc,
                     ASMutName,
                     ASMutDesc,
                     ONSMutName,
                     ONSMutDesc,
                     INVMutName,
                     INVMutDesc,
                     LMSMutName,
                     LMSMutDesc,
                     SpecifyNumberStr,
                     PlayersVSBotsStr,
                     UseRosterStr,
                     MapDefsStr;


function PreBeginPlay(){
  Super.PreBeginPlay();

  BGcolor 				= class'MutGameLogger'.default.backgroundcolor;
  bUseGraphics   	= class'MutGameLogger'.default.bEGSUseGraphics;
  brandomBGcolor 	= class'MutGameLogger'.default.bEGSRandomBGcolor;


	// fool-proof
  if (BGColor >= BGColorsArray.Length || BGColor < 0)
    BGcolor = Rand(BGColorsArray.Length);

  if(bRandomBGcolor){
    BGcolor = Rand(BGColorsArray.Length);
  }
}

// ============================================================================
// DoWriteHeader
//
// This function is called from StartMatch and it calls the WriteHeader here.
// I made it final, to avoid loosing these two lines that set the colored
// variants of team names, when someone overrides WriteHeader in subclass
// ============================================================================
final function DoWriteHeader (string GameType, string MapName){
  ColoredBlueTeamName = baseLogger.CTName(1);
  ColoredredTeamName  = baseLogger.CTName(0);
  WriteHeader(Gametype, MapName);
}

// ============================================================================
// WriteHeader
//
// This function is called from StartMatch and it writes down the heading,
// embedded CSS, and the top "frame" with UT logo if images are enabled
// ============================================================================

function WriteHeader (string GameType, string MapName)
{
  Logf("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
  Logf("<HTML><HEAD>");
  Logf("<TITLE>Details on logged match played on"@BaseLogger.FullTimeDate()@":"@GameType@" at "@MapName@"</title>");
  Logf("<meta name=\"Generator\" content=\"UnrealEngine2 build "$Level.EngineVersion$" - exporter: "$string(BaseLogger.Class)$" v."$BaseLogger.version@"by _Lynx\">");
  expStyle();
  Logf("</head><body bgcolor=\""$GetBGColor()$"\" rightmargin=\"0\" leftmargin=\"0\" topmargin=\"0\" text=\"#000000\" class=text>");
  Logf("<!-- Settings used");
  Logf("bUseColoredNames is"@BaseLogger.bUseColoredNames);
  Logf("bUseColoredTeamNames is"@BaseLogger.bUseColoredTeamNames);
  Logf("PlayerScoreEventsMode is"@BaseLogger.PlayerScoreEventsMode);
  Logf("bShowTeamScoreEvents is"@BaseLogger.bShowTeamScoreEvents);
  Logf("bShowConnectsDisconnects"@BaseLogger.bShowConnectsDisconnects);
  LOgf("bLogOtherPicks is"@BaseLogger.bLogOtherPicks);
  logf("bLogWeaponsPicks is"@BaseLogger.bLogWeaponsPicks);
  logf("bShowSStatus is"@BaseLogger.bShowSStatus);
  Logf("bReportGameEvents is"@BaseLogger.bReportGameEvents);
  Logf("bUseGraphics is"@bUseGraphics);
  Logf("bWSLenabled is"@BaseLogger.bWSLenabled);
  Logf("bLogTalks is"@BaseLogger.bLogTalks);
  Logf("HeavyDamageReportMode is"@BaseLogger.HeavyDamageReportMode);
  Logf("bLogTalks is"@BaseLogger.bDuelMode);
  Logf("-->");

  if(bUseGraphics){
    Logf("<table class=\"top\" width=\"100%\">");
    Logf("<tr>");
    Logf("    <td width=\"100\" align=left><a href=\"http://www.epicgames.com\" class=\"rest\"><img src=\"gameloggerimages/"$imagessubfolder$"/epic.gif\" border=0></a></td><td width=\"*\" align=center><div align=\"center\"><a href=\"http://www.unrealtournament.com\"><Img border=\"0\" src=\"gameloggerimages/"$imagessubfolder$"/ut2k4.jpg\"></a></div></td><td width=100 align=right><a href=\"http://www.atari.com\" class=\"rest\"><img src=\"gameloggerimages/"$imagessubfolder$"/atari.gif\" border=0></a></td>");
    Logf("</tr>");
    Logf("</table>");
  }

  ColoredBlueTeamName = baseLogger.CTName(1);
  ColoredredTeamName  = baseLogger.CTName(0);
}

function LogF(string ThisGoesToLog){
  BaseLogger.Logf(ThisGoesToLog);
}

// ============================================================================
// expStyle
//
// This function is called from WriteHeader and it writes CSS one of two sheets
// depenfing on the bgcolor, if its bright or dark. If bInvert is current BG's
// struct is true, the logger will use the white fonts;
// ============================================================================

function expStyle(){

// styles for bright background
  if (!BGColorsArray[BGcolor].bInvert){
    Logf("<style type=\"text/css\">");
    // just a common text that alsways inherits it's color from the body
    Logf(" .text{");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 11px;");
    Logf(" }");
    // smaller text, used for example in TTM Stats plugin;
    // alsways inherits it's color from the body
    Logf(" .textX{");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 10px;");
    Logf(" }");
    //  smaller text, always black
    Logf(" .textsmall{");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 10px;");
    Logf(" color : #000000;");
    Logf(" }");
		// table style used for report section
    Logf(" TABLE.a{");
    Logf(" border : 1px solid Black;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 10px;");
    Logf(" }");
    // other table style, used f.e. in team scoreboard
    Logf(" TABLE.b{");
    Logf(" border : 0px solid Black;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 11px;");
    Logf(" }");
    // table for the atari, ut and epic logos
    Logf(" TABLE.top{");
    Logf(" background-color : White;");
    Logf(" border-bottom : 2px solid Black;");
    Logf(" border-left : 0px solid Black;");
    Logf(" border-right : 0px solid Black;");
    Logf(" border-top : 0px solid Black;");
    Logf(" }");
    // heading style, used in the "wins the match" string
    // and for the heading in duel and team mode
    Logf(" .heading{");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 17px;");
    Logf(" }");
    // style for blue team part of scoreboard in team games
    Logf(" TABLE.ScoreB{");
    Logf(" border : 1px solid Black;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 13px;");
    Logf(" color : #000000;");
    Logf(" background : #6495ED;");
    Logf(" }");
    // style for red team part of scoreboard in team games
    Logf(" TABLE.ScoreR{");
    Logf(" border : 1px solid Black;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 13px;");
    Logf(" color : #000000;");
    Logf(" background : #FF6347;");
    Logf(" }");
    // style for scoreboard in non-team based gametypes
    Logf(" TABLE.ScoreU{");
    Logf(" border : 1px solid Black;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 13px;");
    Logf(" color : #000000;");
    Logf(" background : #FFFAF0;");
    Logf(" }");
    // style for common link when nothing happens to it
    Logf(" A:link.rest {");
    Logf(" COLOR: Navy;");
    Logf(" font-weight: normal;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    // style for common visited link
    Logf(" A:visited.rest {");
    Logf(" color: Navy;");
    Logf(" font-weight: normal;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    // style for common link when the cursor is hovering on it
    Logf(" A:hover.rest {");
    Logf(" COLOR: Red;");
    Logf(" font-weight: bold;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    // style for link in scoreboard when nothing happens to it
    Logf(" A:link.score {");
    Logf(" COLOR: black;");
    Logf(" font-weight: normal;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    // style for link in scoreboard it was visited
    Logf(" A:visited.score {");
    Logf(" color: black;");
    Logf(" font-weight: normal;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    // style for link in scoreboard when the cursor is hovering on it
    Logf(" A:hover.score {");
    Logf(" COLOR: navy;");
    Logf(" font-weight: bold;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: underline;");
    Logf(" }");
		Logf(" .say{");
		Logf(" color: #D25B04;");
		Logf(" }");
		Logf(" .teamsay_red{");
		Logf(" color: #FF6347;");
		Logf(" }");
		Logf(" .teamsay_blue{");
		Logf(" color: #6495ED;");
		Logf(" }");
		Logf(" .item_pickup{");
		Logf(" color: #2E8B57;");
		Logf(" }");
		Logf(" .weapon_pickup{");
		Logf(" color: #A68D00;");
		Logf(" }");
		Logf(" .HdamageEvent{");
		Logf(" color: #A0522D;");
		Logf(" }");
    Logf(" TD.ScoreR{");
    Logf(" border-bottom : 1px solid #FF4322;");
    Logf(" }");
    Logf(" TD.ScoreB{");
    Logf(" border-bottom : 1px solid #296BE7;");
    Logf(" }");
    Logf(" TD.ScoreU{");
    Logf(" border-bottom : 1px solid #FFEBBF;");
    Logf(" }");
    Logf("</style>");
  }
  else{
  // same as the above but for dark background
    Logf("<style type=\"text/css\">");
    Logf(" .text{");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 11px;");
    Logf(" color : #F8F8FF;");
    Logf(" }");
    Logf(" .textX{");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 10px;");
    Logf(" }");
    Logf(" .textsmall{");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 10px;");
    Logf(" color : #000000;");
    Logf(" }");
    Logf(" TABLE.a{");
    Logf(" border : 1px solid White;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 10px;");
    Logf(" color : #F8F8FF;");
    Logf(" }");
    Logf(" TABLE.b{");
    Logf(" border : 0px solid White;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 11px;");
    Logf(" color : #F8F8FF;");
    Logf(" }");
    Logf(" .heading{");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 17px;");
    Logf(" color : #F8F8FF;");
    Logf(" }");
    Logf(" TABLE.ScoreB{");
    Logf(" border : 1px solid White;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 13px;");
    Logf(" color : #000000;");
    Logf(" background : #6495ED;");
    Logf(" }");
    Logf(" TABLE.ScoreR{");
    Logf(" border : 1px solid White;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 13px;");
    Logf(" color : #000000;");
    Logf(" background : #FF6347;");
    Logf(" }");
    Logf(" TABLE.ScoreU{");
    Logf(" border : 1px solid White;");
    Logf(" font-family : Verdana;");
    Logf(" font-size : 13px;");
    Logf(" color : #000000;");
    Logf(" background : #708090;");
    Logf(" }");
    Logf(" TABLE.top{");
    Logf(" background-color : White;");
    Logf(" border-bottom : 2px solid Black;");
    Logf(" border-left : 0px solid Black;");
    Logf(" border-right : 0px solid Black;");
    Logf(" border-top : 0px solid Black;");
    Logf(" }");
    Logf(" A:link.rest {");
    Logf(" COLOR: Silver;");
    Logf(" font-weight: normal;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    Logf(" A:visited.rest {");
    Logf(" color: Grey;");
    Logf(" font-weight: normal;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    Logf(" A:hover.rest {");
    Logf(" COLOR: Yellow;");
    Logf(" font-weight: bold;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    Logf(" A:link.score {");
    Logf(" COLOR: black;");
    Logf(" font-weight: normal;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    Logf(" A:visited.score {");
    Logf(" color: black;");
    Logf(" font-weight: normal;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: none;");
    Logf(" }");
    Logf(" A:hover.score {");
    Logf(" COLOR: navy;");
    Logf(" font-weight: bold;");
    Logf(" font-style: normal;");
    Logf(" font-variant: normal;");
    Logf(" text-decoration: underline;");
    Logf(" }");
    Logf(" .say{");
    Logf(" color: #DAA520;");
    Logf(" }");
    Logf(" .teamsay_red{");
    Logf(" color: #F08080;");
    Logf(" }");
    Logf(" .teamsay_blue{");
    Logf(" color: #87CEEB;");
    Logf(" }");
    Logf(" .item_pickup{");
    Logf(" color: #9FFF88;");
    Logf(" }");
    Logf(" .weapon_pickup{");
    Logf(" color: #FFE188;");
    Logf(" }");
    Logf(" .HdamageEvent{");
    Logf(" color : #DB7093;");
    Logf(" }");
    Logf(" TD.ScoreR{");
    Logf(" border-bottom : 1px solid #FF4322;");
    Logf(" }");
    Logf(" TD.ScoreB{");
    Logf(" border-bottom : 1px solid #296BE7;");
    Logf(" }");
    Logf(" TD.ScoreU{");
    Logf(" border-bottom : 1px solid #FFEBBF;");
    Logf(" }");
    Logf("</style>");
  }
}

// ============================================================================
// WriteMatchInfo
//
// Writes down server settings and rules for the starting match
// ============================================================================

function WriteMatchInfo(string ngTitle,
                        string ngAuthor,
                        string ngGameGameName,
                        string siServerName,
                        string siAdminName,
                        string siAdminEmail,
                        string siMOTD ){

  local string Player1;
  local string player2;
  local string blueTeamName;
  local string redTeamName;
  local string MutDesc;

  local int FragLimit;
  local int TimeLimit;
  local int MaxSpectators;
  local int NumBots;
  local int MaxPlayers;

  local bool bAllowBehindView;
  local bool bAllowWeaponThrowing;
  local bool bWeaponStay;
  local bool bWeaponShouldViewShake;
  local bool bNoNamesProvided;

  local float GameSpeed;

  local mutator MyMutie;
  local GamereplicationInfo GRI;

// rofl... never saw such an error -
// Error: F:\UT2004\GameLogger\Classes\GameLoggerHTMLwrapper.uc(302) :
// Error, 'WriteMatchInfo': too many parameters
// That's how it looked before - saving for history =)
// function WriteMatchInfo(string redTeamName,
//                        string blueTeamName,
//                        string ngTitle,
//                        string ngAuthor,
//                        string ngGameGameName,
//                        string FragLimit,
//                        string TimeLimit,
//                        string GameSpeed,
//                        string MaxSpectators,
//                        string NumBots,
//                        string MaxPlayers,
//                        string bAllowBehindView,
//                        string bAllowWeaponThrowing,
//                        string bWeaponShouldViewShake,
//                        string bWeaponStay,
//                        string siServerName,
//                        string siAdminName,
//                        string siAdminEmail,
//                        string siMOTD ){
// So I decided to move recieve non-string values here (String values got
// parsed and tabs in there are replaced with an underscore)

  FragLimit       				= Level.Game.GoalScore;
  TimeLimit       			  = Level.Game.TimeLimit;
  GameSpeed      				  = Level.Game.GameSpeed;
  MaxSpectators   				= Level.Game.MaxSpectators;
  NumBots         				= Level.Game.NumBots;
  MaxPlayers      				= Level.Game.MaxPlayers;
  bAllowBehindView 				= Level.Game.bAllowBehindView;
  bAllowWeaponThrowing 		= Level.Game.bAllowWeaponThrowing;
  bWeaponShouldViewShake 	= Level.Game.bWeaponShouldViewShake;
  bWeaponStay     				= Level.Game.bWeaponStay;

  GRI = Level.Game.GameReplicationInfo;

  blueTeamName = GRI.Teams[1].TeamName;
  redTeamname  = GRI.Teams[0].TeamName;

  if (baseLogger.bDuelMode &&
			class'MutGameLogger'.default.MyBlueTeamName != "" &&
			class'MutGameLogger'.default.MyRedTeamName != ""){
    Player1 = class'MutGameLogger'.default.MyRedTeamName;
    Player2 = class'MutGameLogger'.default.MyBlueTeamName;
  }
  else {
    bNoNamesProvided = True;
  }

  if (baseLogger.IsTeamGame){
    Logf("<div align=center class=heading>");
    Logf("");
    Logf(redTeamName@"vs"@blueTeamName);
    Logf("<div align=center class=text>");
    Logf("Match played on"@baseLogger.FullTimeDate());
    Logf("</div>");
    Logf("</div>");
    Logf("<br>");
  }
  else if (baseLogger.bDuelMode && !bNoNamesProvided){
    Logf("<div align=center class=heading>");
    Logf("<br><br>");
    Logf(Player1@"vs"@Player2);
    Logf("<div align=center class=text>");
    Logf("Match played on"@baseLogger.FullTimeDate());
    Logf("</div>");
    Logf("</div>");
    Logf("<br>");
  }
  else{
    Logf("<br><br>");
  }

  Logf("<div align=\"center\">");
  Logf("<table width=600 class=\"b\" border=1>");
  Logf("<tr>");
  Logf("<td width=200>Arena Name</td><td colspan=3 width=400>"$ngTitle$"&nbsp;</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td width=200>Admin:</td><td colspan=3 width=400>"$siAdminName$"&nbsp;</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td width=200>e-mail:</td><td colspan=3 width=400><a href=\"mailto:"$siAdminEmail$"\" class=rest>"$siAdminEmail$"&nbsp;</a></TD>");
  Logf("</tr>");
  Logf("<tr>");
  //to avoid link to nowhere.
  if(baseLogger.serverIP != ""){
  	Logf("<td width=200>Server Name:</td><td colspan=3 width=400><a href=\"ut2004://"$BaseLogger.serverIP$"\" class=rest>"$siServerName$"&nbsp;</a></TD>");
  }
  else{
    Logf("<td width=200>"$baseLogger.ServerName$"</td><td colspan=3 width=400>"$siServerName$"&nbsp;</TD>");
  }
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td width=200>Server Type</td><td colspan=3 width=400>"$GetServerType()$"&nbsp;</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td colspan=4 align=center width=100%>"$B("Mutators used:")$"</td>");
  Logf("</tr>");
  FillMutDefs();
  foreach AllActors(class'Mutator',MyMutie)
  {
     MutDesc = MyMutie.default.Description;
     replacetext (MutDesc, "|", "<BR>");
     Logf("<tr>");
     Logf("<td align=left width=200 valign=top>"$MyMutie.default.FriendlyName$"("$MyMutie.Class$")</TD>");
     Logf("<TD colspan=3 align=left width=400>"$MutDesc$"&nbsp;</TD>");
     Logf("</tr>");
  }
  ClearMutDefs();
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td colspan=4 align=center width=100%>"$B("Game Rules")$"</td>");
  Logf("</TR>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Goal Score:</strong></TD><TD colspan=3>"$FragLimit$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Timelimit:</strong></TD><TD colspan=3>"$TimeLimit$" min.</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Weapon Stay:</strong></TD><TD colspan=3>"$bWeaponstay$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Gamespeed</strong></TD><TD colspan=3>"$int(Gamespeed * 100)$"%</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Bot Mode</strong></TD><TD colspan=3>"$DecodeBotMode(UnrealMPGameInfo(Level.Game).BotMode)$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Spawn Protection Time</strong></TD><TD colspan=3>"$int(DeathMatch(Level.Game).SpawnProtectionTime)$" sec.</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Weapon Shakes View</strong></TD><TD colspan=3>"$bWeaponShouldViewShake$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Allow Behind View</strong></TD><TD colspan=3>"$Level.Game.bAllowBehindView$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Allow Weapon Throwing</strong></TD><TD colspan=3>"$Level.Game.bAllowWeaponThrowing$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Allow Translocator</strong></TD><TD colspan=3>"$DeathMatch(Level.Game).bAllowTrans$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Force Respawn</strong></TD><TD colspan=3>"$DeathMatch(Level.Game).bForceRespawn$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Colored DM Skins</strong></TD><TD colspan=3>"$DeathMatch(Level.Game).bColoredDMSkins$"</TD>");
  Logf("</tr>");

  if (baseLogger.IsTeamGame){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Friendly Fire Scale</strong></TD><TD colspan=3>"$int(TeamGame(Level.Game).FriendlyFireScale * 100)$"%</TD>");
    Logf("</tr>");
  }

  if (Level.GetGameClass() == class'ONSOnslaughtGame'){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Overtime Core Drainage</strong></TD><TD colspan=3>"$ONSOnslaughtGame(Level.Game).OvertimeCoreDrainPerSec$"</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Team Swap Sides</strong></TD><TD colspan=3>"$ONSOnslaughtGame(Level.Game).bSwapSidesAfterReset$"</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Link Setup Used:</strong></TD><TD colspan=3>"$ONSOnslaughtGame(Level.Game).CurrentSetupName$"</TD>");
    Logf("</tr>");
  }

  if (Level.GetGameClass() == class'xBombingRun'){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Ball Launcher Drains Traslocator</strong></TD><TD colspan=3>"$xBombingRun(Level.Game).bBallDrainsTransloc$"</TD>");
    Logf("</tr>");
  }
  if (Level.GetGameClass() == class'ASGameInfo'){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Round Limit</strong></TD><TD colspan=3>"$ASGameInfo(Level.Game).RoundLimit$"</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Round Time Limit</strong></TD><TD colspan=3>"$ASGameInfo(Level.Game).RoundTimeLimit$"</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Reinforcement Frequency</strong></TD><TD colspan=3>"$ASGameInfo(Level.Game).ReinforcementsFreq$" sec.</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Online Practice Time Limit</strong></TD><TD colspan=3>"$ASGameInfo(Level.Game).PracticeTimeLimit$" sec.</TD>");
    Logf("</tr>");
  }
  if (Level.GetGameClass() == class'xDoubleDom'){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Time To Score</strong></TD><TD colspan=3>"$xDoubleDom(Level.Game).TimeToScore$" sec.</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Time Disabled</strong></TD><TD colspan=3>"$xDoubleDom(Level.Game).TimeDisabled$" sec.</TD>");
    Logf("</tr>");
  }

  Logf("<tr>");
  Logf("<td align=center colspan=4 width=100%><strong>Message Of The Day</strong></TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=center colspan=4 width=100%>"$siMOTD$"</TD>");
  Logf("</tr>");
  Logf("</table>");
  Logf("</div>");
  LogF("<BR>");
  LogF("<BR>");
  StartReportTable();
}


// ============================================================================
// StartReportTable
//
// This writes down beginning of thereport table, defining it's style and
// column sizes and also the table header
// ============================================================================
function StartReportTable(){
  LogF("<div align=center>");
  Logf("<table width=\"98%\" class=a>");
  LogF("<tr><td colspan=2 width=100% align=center><strong>Match report</strong></td></tr>");
}

// ============================================================================
// WritereportTableEnd
//
// Writes the ending tags of the report table
// If you changed the above function, it's most likely you'll have to edit this
// one
// ============================================================================
function WritereportTableEnd(){
  Logf("</table>");
  Logf("</div>");
}

// ============================================================================
// StartGame
//
// Writes a "Match Started" string
// ============================================================================
function StartGame(string TimeWhen){
  WriteSingleReportString(TimeWhen, baseLogger.GameStartedMsg);
}

// ============================================================================
//  WriteSingleReportString
// This function writes a usual string for a report itself whicj is formatted
// like table. The function actually makes HTML code for the string like this:
//
//  |------------|---------------------------------------------------|
//  |  Timestamp |  whatshappened                                    |
//  |------------|---------------------------------------------------|
//
// ============================================================================

function WriteSingleReportString (string Timestamp, string whatshappened){
  Logf("<tr>");
  Logf("<td width=40>"@B(TimeStamp)@"</td><td>"$whatshappened$"</TD>");
  Logf("</tr>");
}

// ============================================================================
//  WriteColspanTwoString
// same as previos but both columns are united in one
// result:
//
//  |------------|---------------------------------------------------|
//  |  contents                                                      |
//  |------------|---------------------------------------------------|
//
// ============================================================================

function WriteColspanTwoString (string contents){
  Logf("<tr>");
  Logf("<td colspan=2 width=100% align=center>"$contents$"</TD>");
  Logf("</tr>");
}

// ============================================================================
//  WriteScoreBoardHeader
// Writes scoreboard header.
// Simple table for usual matches like DM or Invasion:
//
//   <------------------------ 400 pixels ------------------------->
//  |---------------------------------------------------------------|
//  |                                                               |
//  |---------------------------------------------------------------|
//
// table for teambased gametypes:
//
//   <------------------------ 702 pixels ------------------------->
//  |-------------------------------|-------------------------------|
//  | <--------- 351 pixel--------->|                               |
//  |-------------------------------|-------------------------------|
//
// ============================================================================

function WriteScoreBoardHeader(){
  Logf("<a name=\"scores\">");
  if (baseLogger.IsTeamGame){
    Logf("<div align=center>");
    Logf("<table class=b width=702>");
    Logf("<TR width=100% align=center valign=top>");
  }
  else{
    Logf("<BR>");
    Logf("<div align=center>");
   Logf("<table class=ScoreU width=400 align=center>");
  }
}


// ============================================================================
//  WriteScoreBoard
// Writes a table inside the scoreboard table.
// Simple table for usual matches like DM or Invasion:
//
//   <------------------------ 400 pixels ------------------------->
//  |-----------------------------------------------|---------------|
//  |         Player Name                           |     Score     |
//  |-----------------------------------------------|---------------|
//            <---------- 300px ---------->           <-- 100px -->
//   For team games:
//
//  2x
//    <----------------- 350 pixels --------------->
//  |-------------------------------------------------|
//  |                    Team Name                    |
//  |-------------------------------------------------|
//  |                   Team Score                    |
//  |-----------------------------------|-------------|
//  |   Player                          |  his score  |
//  |-----------------------------------|-------------|
//    <----------- 250 px ----------->    <-- 50px -->
//
// ============================================================================

function WriteScoreboard(array<PlayerReplicationInfo> PRIs, GameReplicationInfo GRI){
  local int x;

  if (baseLogger.IsTeamGame){ // Teamgame

    Logf("<TD width=351 align=center valign=top>");
    Logf("<table class=ScoreR width=350>");

    // red team name and score
    Logf("<tr width=100% align=center><td colspan=2>"$B(baseLogger.CTName(0, True))$"</td></tr>");
    Logf("<tr width=100% align=center><td colspan=2>"$B(string(int(GRI.Teams[0].Score)))$"</td></tr>");

    // red team players
    for (x = 0; x<PRIs.Length; x++){
      if (PRIs[x].Team.TeamIndex == 0){
        if ( PRIs[x].PlayerName != "WebAdmin" || !PRIs[x].bOnlySpectator && !PRIs[x].bIsSpectator){

          if (baseLogger.bExportDetailedStats){
            Logf("<tr>");
            Logf("<td width=250 align=left><a class=score href=\"#"$PRIs[x].PlayerID$"\">"$B(PRIs[x].PlayerName)$"</a></td><td width=50 align=center>"$int(PRIs[x].Score)$"</TD>");
            Logf("</tr>");
          }
          else{
            Logf("<tr>");
            Logf("<td width=250 align=left>"$B(PRIs[x].PlayerName)$"</td><td width=50 align=center>"$int(PRIs[x].Score)$"</TD>");
            Logf("</tr>");
          }

        }
      }
    }
    Logf("</table>");
    // end of read team built-in table

    Logf("</TD>");
    Logf("<TD width=351 align=center valign=top>");

    Logf("<table class=ScoreB width=350>");
    // blue team name and score
    Logf("<tr width=100% align=center><td colspan=2>"$B(baseLogger.CTName(1, True))$"</td></tr>");
    Logf("<tr width=100% align=center><td colspan=2>"$B(string(int(GRI.Teams[1].Score)))$"</td></tr>");
    // blue team players
    for (x = 0; x<PRIs.Length; x++){
      if (PRIs[x].Team.TeamIndex == 1){
        if ( PRIs[x].PlayerName != "WebAdmin" && !PRIs[x].bOnlySpectator ){
          if (baseLogger.bExportDetailedStats){
            Logf("<tr>");
            Logf("<td width=250 align=left><a class=score href=\"#"$PRIs[x].PlayerID$"\">"$B(PRIs[x].PlayerName)$"</a></td><td width=50 align=center>"$int(PRIs[x].Score)$"</TD>");
            Logf("</tr>");
          }
          else{
            Logf("<tr>");
            Logf("<td width=250 align=left>"$B(PRIs[x].PlayerName)$"</td><td width=50 align=center>"$int(PRIs[x].Score)$"</TD>");
            Logf("</tr>");
          }
        }
      }
    }
    Logf("</table>");
  }
  else{ // not a Teamgame
    for (x = 0; x<PRIs.Length; x++){
      if ( PRIs[x].PlayerName != "WebAdmin" && !PRIs[x].bOnlySpectator ){
        if (baseLogger.bExportDetailedStats){
          Logf("<tr>");
          Logf("<td width=300 align=left><a class=score href=\"#"$PRIs[x].PlayerID$"\">"$B(PRIs[x].PlayerName)$"</a></td><td width=100 align=center>"$int(PRIs[x].Score)$"</TD>");
          Logf("</tr>");
        }
        else{
          Logf("<tr>");
          Logf("<td width=300 align=left>"$B(PRIs[x].PlayerName)$"</td><td width=100 align=center>"$int(PRIs[x].Score)$"</TD>");
          Logf("</tr>");
        }
      }
    }
  }
}

function WriteScoreBoardBottom(){
  if (baseLogger.IsTeamGame){
    Logf("</TD>");
    Logf("</TR>");
    Logf("</table>");
    Logf("</div>");
  }
  else{
    Logf("</table>");
    Logf("</div>");
  }
}

function WriteDetailedPlayerStats(array<PlayerReplicationInfo> PRIs){
  local int y;
  local string thisstyle;

  Logf("<div align=center>");

  for (y = 0; y<PRIs.Length; y++){
    if(!PRIs[y].bOnlySpectator){
      thisstyle = GetSuitableStyle(PRIs[y].Team.TeamIndex);

      Logf("<br>");
      Logf("<table class="$thisstyle$" width=800 align=center>");
      Logf("<tr>");
      Logf("<td colspan=2 width=100% align=center><a name="$PRIs[y].PlayerID$">Individual stats for"@PRIs[y].PlayerName$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200 class="$thisstyle$">Kills:</td><td class="$thisstyle$" width=\"*\" align=center>"$PRIs[y].Kills$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200 class="$thisstyle$">Deaths:</td><td class="$thisstyle$" width=\"*\" align=center>"$int(TeamPlayerReplicationInfo(PRIs[y]).Deaths)$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200 class="$thisstyle$">Suicides:</td><td class="$thisstyle$" width=\"*\" align=center>"$TeamPlayerReplicationInfo(PRIs[y]).Suicides$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200 class="$thisstyle$">Ping:</td><td class="$thisstyle$" width=\"*\" align=center>"$PRIs[y].Ping$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200 class="$thisstyle$">Packet Loss:</td><td class="$thisstyle$" width=\"*\" align=center>"$PRIs[y].PacketLoss$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200 class="$thisstyle$">Headshots:</td><td class="$thisstyle$" width=\"*\" align=center>"$TeamPlayerReplicationInfo(PRIs[y]).headcount$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200 class="$thisstyle$">Successful shock combos:</td><td class="$thisstyle$" width=\"*\" align=center>"$TeamPlayerReplicationInfo(PRIs[y]).combocount$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200 class="$thisstyle$">Flag touches:</td><td class="$thisstyle$" width=\"*\" align=center>"$TeamPlayerReplicationInfo(PRIs[y]).FlagTouches$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200 class="$thisstyle$">Flag returns:</td><td class="$thisstyle$" width=\"*\" align=center>"$TeamPlayerReplicationInfo(PRIs[y]).FlagReturns$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td width=200>Goals scored:</td><td width=\"*\" align=center>"$PRIs[y].GoalsScored$"</td>");
      Logf("</tr>");
      // note that the stats plugins will just append more rows to the table.
      // The current problem is that extra stats plugins handle the code by themselves;
      // thinking how to make it.
      baseLogger.GetExtraStatsFromPlugins(PRIs[y], thisstyle);
      Logf("<tr>");
      Logf("<td colspan=2 width=100% align=center>&nbsp</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td colspan=2 width=100% align=center>"$Getawards(TeamPlayerReplicationInfo(PRIs[y]))$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td colspan=2 width=100% align=center>Adrenalin combos:</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td colspan=2 width=100% align=center>"$GetCombos(TeamPlayerReplicationInfo(PRIs[y]))$"</td>");
      Logf("</tr>");
      Logf("<tr>");
      Logf("<td colspan=2 width=100% align=center>Awards:</td>");
      Logf("<tr>");
      Logf("<td colspan=2 width=100%><div align=center class=textX><a class=score href=\"#scores\">back to scoreboard</a></div></td>");
      Logf("</tr>");
      Logf("<table>");
    }
  }
  Logf("</div>");
}

final function WriteDocumentEnd(string Winner){
  WriteEnding(winner);
  WriteCopyright();
}

function WriteEnding(string winner){
  Logf("<br>");
  Logf("<br>");
  if (bUseGraphics){
    Logf("<table width=100% height=49 border=0 cellspacing=\"-2\">");
    Logf("<tr>");
    Logf("<td width=81 background=\"gameloggerimages/"$imagessubfolder$"/bar1.gif\" height=\"49\"></td>");
    Logf("<td width=\"*\" height=\"49\" background=\"gameloggerimages/"$imagessubfolder$"/bar2.gif\" class=heading><font color=white><strong><div align=\"center\">"$Winner@"wins the match</div></strong></font></td>");
    Logf("</tr>");
    Logf("</table>");
  }
  else{
    Logf("<hr width=95% size=1 noshade>");
  }
}

final function WriteCopyright(){
  Logf("<br>");
  Logf("<div align=center>");
  Logf("Log created by Game Logger v."$baseLogger.Version$"<br>");
  Logf("UnrealEngine2.5 build "$Level.EngineVersion$"<br>");
  Logf("GameLogger is made by <a class=rest href=\"mailto:unreal-pz@narod.ru\" >Michael \"_Lynx\" Sokolkov</a>2004-2005");
  Logf("<br>");
  Logf("Project homepage: <a class=rest href=\"http://unreal-pz.narod.ru/en/matchlogger.html\" class=rest>http://unreal-pz.narod.ru/en/matchlogger.html</a>");
  Logf("<br>");
  Logf("<br>");
  Logf("Unreal Tournament 2004 2004 Epic Games Inc. All Rights Reserved.");
  Logf(" Unreal Tournament and Unreal Tournament logo are registred trademarks of Epic Games Inc.");
  Logf(" All other trademarks and names, and places of origin mentioned above are property of their respected owners.");
  Logf("<br>");
  Logf("<br>");
  Logf("</div>");
  Logf("</body>");
  Logf("</html>");
}


// ============================================================================
// utility functions used in formatting HTML text;
// ============================================================================
// B
//
// Makes input string bold look bold in HTML
// ============================================================================
function string B( string usualstring )
{
 local string result;

 result = "<strong>"$usualstring$"</strong>";

 return result;
}


// ============================================================================
// Em
//
// Wraps given string with <em></em> tags
// ============================================================================
function string em( string usualstring )
{
 local string result;

 result = "<em>"$usualstring$"</em>";

 return result;
}


// ============================================================================
// GetBGColor()
//
// returns background color from bgcolors array. to point out array element
// config variable BGcolor is used.
// ============================================================================

function string GetBGColor()
{
   return BGColorsArray[BGcolor].ColorHex;
}


// ============================================================================
// GetSuitableStyle
//
// Returns the CSS style name to use for
// scoreboard in team games
// inputTI is an index of the team. there are now four indexes in UT2004, while
// actually only two are being used:
// 0 - red
// 1 - blue
// 2 - green
// 3 - blue
// ============================================================================
function string GetSuitableStyle(int inputTI)
{
  local string result;

  if (BaseLogger.IsTeamGame && inputTI == 0)
    result = "ScoreR";
  else if (BaseLogger.IsTeamGame && inputTI == 1)
    result = "ScoreB";
  else
    result = "ScoreU";

  return result;
}


// ============================================================================
// utility functions used by HTML wrapper f.e. in writing
// game info header
// ============================================================================
// DecodeBotMode
//
// Returns the botmode being used on server
// from given BotMode byte
// ============================================================================
function string DecodeBotMode( byte BotMode)
{
  local string result;

  // 0: SP - Use MinPlayers 5: SP - Use Map defaults 2: SP - Use Roster
  // 4: MP - UseMinPlayers 8: MP: Use Roster  16: players vs bots

  if (BotMode == 0 || BotMode == 4 || BotMode == 8){
    result = SpecifyNumberStr@"("$UnrealMPGameInfo(Level.Game).MinPlayers$")";
  }
  if (BotMode == 2 || BotMode == 6 || BotMode == 10){
    result = UseRosterStr;
  }
  if (BotMode == 5 || BotMode == 1){
    result = MapDefsStr;
  }
  if (BotMode == 16 ){
    result = PlayersVSBotsStr@"(Ratio:"@UnrealMPGameInfo(Level.Game).BotRatio$")";
  }

  Log("UnrealMPGameInfo.BotMode =="@BotMode);

  return result;
}


// ============================================================================
// GetServerType
//
// returns the server mode
// ============================================================================

function string GetServerType()
{
  if (Level.NetMode==NM_Standalone){return "Standalone game";}
  if (Level.NetMode==NM_DedicatedServer){return "Dedicated Server";}
  if (Level.NetMode==NM_ListenServer){return "Listen Server";}
}

// ============================================================================
// GetAwards
//
// Returns the string with all awards won by player Who during the match
// f.e. "First Blood! Head Hunter! Killing Spree! x1 WICKED SICK! x1"
// ============================================================================

function string GetAwards(TeamPlayerReplicationInfo Who)
{
  local string result;

  if ( who.bFirstBlood )
    result = "First Blood! ";
  if ( Who.flakcount >= 15 )
    result = result@"Flak Monkey! ";
  if ( Who.combocount >= 15 )
    result = result@"Combo Whore! ";
  if ( Who.headcount >= 15 )
    result = result@"Head Hunter! ";
  if ( Who.ranovercount >= 10 )
    result = result@"Road Rage! ";
  if ( Who.DaredevilPoints > 0 )
    result = result@"Daredavil:"@Who.DaredevilPoints@" ";
  if ( Who.GoalsScored >= 3 )
    result = result@"Hat Trick!";
  if ( Who.Spree[0] > 0 )
    result = result@class'KillingSpreeMessage'.default.SelfSpreeNote[0]@"x"$Who.Spree[0]@" ";
  if ( Who.Spree[1] > 0 )
    result = result@class'KillingSpreeMessage'.default.SelfSpreeNote[1]@"x"$Who.Spree[1]@" ";
  if ( Who.Spree[2] > 0 )
    result = result@class'KillingSpreeMessage'.default.SelfSpreeNote[2]@"x"$Who.Spree[2]@" ";
  if ( Who.Spree[3] > 0 )
    result = result@class'KillingSpreeMessage'.default.SelfSpreeNote[3]@"x"$Who.Spree[3]@" ";
  if ( Who.Spree[4] > 0 )
    result = result@class'KillingSpreeMessage'.default.SelfSpreeNote[4]@"x"$Who.Spree[4]@" ";
  if ( Who.Spree[5] > 0 )
    result = result@class'KillingSpreeMessage'.default.SelfSpreeNote[5]@"x"$Who.Spree[5]@" ";
  if ( Who.MultiKills[0] > 0 )
    result = result@class'DMStatsScreen'.default.KillString[0]@"x"$Who.Multikills[0]@" ";
  if ( Who.MultiKills[1] > 0 )
    result = result@class'DMStatsScreen'.default.KillString[1]@"x"$Who.Multikills[1]@" ";
  if ( Who.MultiKills[2] > 0 )
    result = result@class'DMStatsScreen'.default.KillString[2]@"x"$Who.Multikills[2]@" ";
  if ( Who.MultiKills[3] > 0 )
    result = result@class'DMStatsScreen'.default.KillString[3]@"x"$Who.Multikills[3]@" ";
  if ( Who.MultiKills[4] > 0 )
    result = result@class'DMStatsScreen'.default.KillString[4]@"x"$Who.Multikills[4]@" ";
  if ( Who.MultiKills[5] > 0 )
    result = result@class'DMStatsScreen'.default.KillString[5]$"x"$Who.Multikills[5]@" ";
  if ( Who.MultiKills[6] > 0 )
    result = result@class'DMStatsScreen'.default.KillString[6]$"x"$Who.Multikills[6]@" ";

  return result;
}


// ============================================================================
//  GetCombos
//
// Returns the string with all combos performed by a player Who during the
// match (i.e.  Berserk x1 Defensive x5)
// ============================================================================
function string GetCombos(TeamPlayerReplicationInfo who){
  local string result;

  if ( Who.Combos[0] > 0 )
    result = class'DMStatsScreen'.default.ComboNames[0]@"x"@Who.Combos[0]@" ";
  if ( Who.Combos[1] > 0 )
    result = result@class'DMStatsScreen'.default.ComboNames[1]@"x"$Who.Combos[1]@" ";
  if ( Who.Combos[2] > 0 )
    result = result@class'DMStatsScreen'.default.ComboNames[2]@"x"$Who.Combos[2]@" ";
  if ( Who.Combos[3] > 0 )
    result = result@class'DMStatsScreen'.default.ComboNames[3]@"x"$Who.Combos[3]@" ";
  if ( Who.Combos[4] > 0 )
    result = result@class'DMStatsScreen'.default.ComboNames[4]@"x"$Who.Combos[4]@" ";

  return result;
}

// ============================================================================
// ColorTeamName
//
// This function wraps is being called from EGameStats.CTName and wraps
// the given team name around with tags to display the team name with
// appropriate color.
// ============================================================================

function string ColorTeamName(string BlueTeamName, int TeamIndex){
 local string colorname;

 if (TeamIndex == 0){
  colorname="red";
 }
 else if (TeamIndex == 1){
  colorname="blue";
 }
 else if (TeamIndex == 2){
  colorname="green";
 }
 else if (TeamIndex == 3){
  colorname="yellow";
 }
 return "<font color=\""$colorname$"\">"$BlueTeamName$"</font>";
}

// ============================================================================
// ColorPlayerName
//
// The same as the above but for players' names, so that you can alter their
// appearance
// ============================================================================

function string ColorPlayerName(string PlayerName, int TeamIndex){
 local string colorname;

 if (TeamIndex == 0){
  colorname="red";
 }
 else if (TeamIndex == 1){
  colorname="blue";
 }
 else if (TeamIndex == 2){
  colorname="green";
 }
 else if (TeamIndex == 3){
  colorname="yellow";
 }
 return "<font color=\""$colorname$"\">"$PlayerName$"</font>";
}



// ============================================================================
// FillMutDefs()
//
// This function fills in default names and descriptions for gametype mutators
// because they're always listed in mutators list but don't have even name
// to say nothing about the description.
// ============================================================================
function FillMutDefs()
{
  class'DMMutator'.default.FriendlyName = DMMutName;
  class'DMMutator'.default.Description = DMMutDesc;
  class'ASMutator'.default.FriendlyName = ASMutName;
  class'ASMutator'.default.Description = ASMutDesc;
  class'ONSDefaultMut'.default.FriendlyName = ONSMutName;
  class'ONSDefaultMut'.default.Description = ONSMutDesc;
  class'InvasionMutator'.default.FriendlyName = INVMutName;
  class'InvasionMutator'.default.Description = INVMutDesc;
  class'MutLastManStanding'.default.FriendlyName = LMSMutName;
  class'MutLastManStanding'.default.Description = LMSMutDesc;
}


// ============================================================================
// ClearMutDefs()
//
// cleaning after ourselves
// ============================================================================

function ClearMutDefs()
{
  class'DMMutator'.default.FriendlyName = "";
  class'DMMutator'.default.Description = "";
  class'ASMutator'.default.FriendlyName = "";
  class'ASMutator'.default.Description = "";
  class'ONSDefaultMut'.default.FriendlyName = "";
  class'ONSDefaultMut'.default.Description = "";
  class'InvasionMutator'.default.FriendlyName = "";
  class'InvasionMutator'.default.Description = "";
  class'MutLastManStanding'.default.FriendlyName = "";
  class'MutLastManStanding'.default.Description = "";
}


DefaultProperties
{
  BGcolor=1
  BGColorsArray(0)=(ColorHex="#DFDFDF")
  BGColorsArray(1)=(ColorHex="#2F4F4F",bInvert=True)
  BGColorsArray(2)=(ColorHex="#ffffff")
  BGColorsArray(3)=(ColorHex="#191970",bInvert=True)
  BGColorsArray(4)=(ColorHex="#c7c28b")
  BGColorsArray(5)=(ColorHex="#000000",bInvert=True)
  BGColorsArray(6)=(ColorHex="#4b0082",bInvert=True)
  BGColorsArray(7)=(ColorHex="#696969",bInvert=True)
  BGColorsArray(8)=(ColorHex="#04376A",bInvert=True)
  BGColorsArray(9)=(ColorHex="#024630",bInvert=True)
  BGColorsArray(10)=(ColorHex="#971B04",bInvert=True)
  BGColorsArray(11)=(ColorHex="#ff8000")
  BGColorsArray(12)=(ColorHex="#283c80",bInvert=True)
  BGColorsArray(13)=(ColorHex="#d8a808")
  BGColorsArray(14)=(ColorHex="#17191b",bInvert=True)
  bUseGraphics=true
  brandomBGcolor=false
  imagessubfolder="default"
  DMMutName="Base Rules Mutator"
  DMMutDesc="Controls some basic match settings, like brightskins and air control"
  ASMutName="Base AS Rules Mutator"
  ASMutDesc="Controls some basic match settings, like brightskins and air control"
  ONSMutName="Base ONS Rules Mutator"
  ONSMutDesc="Controls some basic match settings, like brightskins and air control"
  INVMutName="Base INV Rules Mutator"
  INVMutDesc="Controls some basic match settings, like brightskins and air control"
  LMSMutName="Base LMS Rules Mutator"
  LMSMutDesc="Controls some basic match settings, like brightskins and air control"
  SpecifyNumberStr="Specified Number"
  PlayersVSBotsStr="Players vs Bots"
  UseRosterStr="Rostered Bots"
  MapDefsStr="Map Default Number"
}
