/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_UltraGib extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  if (ClassIsChildOf(W.Class, class'UTWeap_Stinger')) return false;
  return true;
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  local PlayerController PC;
  local BPRIDATA BD;

  if (Damage != 0 && P != None && P.Owner != None) {
    PC = PlayerController (P.Owner);
    if (PC != None) {
      BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);
      if (BD.Mana >= Level * 2) { // Takes Mana per hit
        BD.Mana -= Level * 2;
        class'BattleStaticFunctions'.static.WriteBPRI (PC.PlayerReplicationInfo, BD);
        Damage = Damage * (1.0 + Level * 0.5);
      }
    }
  }
}

defaultproperties
{
  MagicName = "Ultra GIB";
  MagicMaxLevel = 5;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_LiquidBlue';
  bPositiveMagic = true;
  DamageChangePercentage = 50;
}