/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

`include (BattleRPG/Classes/BattleRPG.uci)

class BattleMenuPanel_AbilityDescription extends UTDrawPanel;

var BattleMainMenu BMM;

event PostInitialize()
{
  BMM = BattleMainMenu (GetScene());
}

event DrawPanel()
{
  local BattlePlayerController BPC;

  Canvas.Font = class'Engine'.static.GetLargeFont();
  Canvas.SetDrawColor(255,255,255,200);
  Canvas.SetPos (0,3);
  if (BMM.BPC != None) {
    BPC = BMM.BPC;
    BPC.BMM = BMM;
    Canvas.DrawText (BPC.PanelAbilityDescription);
    BPC.MenuVisible = true;
  }
}

defaultproperties
{
}