/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

`include (BattleRPG/Classes/BattleRPG.uci)

class BattleInteraction extends Interaction;

var name MenuKey;
var name PrevArtifactKey;
var name NextArtifactKey;
var name UseArtifactKey;

var BattlePlayerController BPC;

function bool InputKey (int ControllerId, name Key, EInputEvent EventType, optional float AmountDepressed=1.f, optional bool bGamepad)
{
  local UIScene Scene;
  local GameUISceneClient GS;
  local BPRIDATA BD;

  if (Key == UseArtifactKey && EventType == IE_Pressed) {
    BPC.UseArtifact();
  }
  if (Key == PrevArtifactKey && EventType == IE_Pressed) {
    BPC.PrevArtifact();
  }
  if (Key == NextArtifactKey && EventType == IE_Pressed) {
    BPC.NextArtifact();
  }
  if (Key == MenuKey && EventType == IE_Pressed && BPC.ReplicatedDynamicAbilitiesLength > 0 && BPC.PlayerReplicationInfo != None) {
    BD = class'BattleStaticFunctions'.static.ReadBPRI (BPC.PlayerReplicationInfo);
    if (BD.Level > 0) {
      GS = UTGameUISceneClient (class'UIRoot'.static.GetSceneClient());
      Scene = UIScene(DynamicLoadObject("BattleRPGContent.MainMenu", class'UIScene'));
	  if (Scene != None) {
        if (BattleMainMenu(Scene) != None) BattleMainMenu(Scene).BPC = BPC;
        BPC.UpdateCostData ();
        GS.OpenScene(Scene);
	  }
    }
  }
  return false;
}

defaultproperties
{ 
   MenuKey="L"
   PrevArtifactKey="LeftBracket";
   NextArtifactKey="RightBracket";
   UseArtifactKey="U";
   __OnReceivedNativeInputKey__Delegate=Default__BattleInteraction.InputKey
   Name="Default__BattleInteraction"
   ObjectArchetype=Interaction'Engine.Default__Interaction'
}