/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleArtifactInstant_MaxMagic extends BattleArtifactInstant config (BattleRPG);

function ActivateInstantArtifact (UTPawn P)
{
  local UTWeapon UTW;
  local BWEAPDATA BW;
  local PlayerController PC;
  local PlayerReplicationInfo PRI;
  local BPRIDATA BD;

  if (P != None && WorldInfo != None) {
    UTW = UTWeapon(P.Weapon);
    PC = PlayerController (P.Owner);
    if (UTW != None) {
      BW = class'BattleStaticFunctions'.static.ReadWEAP (UTW);
      if (BW.ActiveBWMLevel >= 1 && BW.ActiveBWM != None && BW.ActiveBWM.bPositiveMagic) {
        if (BW.ActiveBWMLevel < BW.ActiveBWM.MagicMaxLevel) {
          BW.ActiveBWMLevel = BW.ActiveBWM.MagicMaxLevel;
          class'BattleStaticFunctions'.static.WriteWEAP (UTW, BW);
          class'BattleStaticFunctions'.static.Message2Pawn (P, "newweaponmagic", "Your weapon is now: "@BW.ActiveBWM.MagicDescription (BW.ActiveBWMLevel));
        } else {
          class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "Current weapon already has max magic"); 
          // Give the player a refund
          PRI = PC.PlayerReplicationInfo;
          if (PRI != None) {
            BD = class'BattleStaticFunctions'.static.ReadBPRI (PRI);
            BD.Mana = BD.Mana + ManaUsage;
            class'BattleStaticFunctions'.static.WriteBPRI (PRI, BD);
          }
        }
      } else {
        if (PC != None) {
          if (BW.ActiveBWM != None) {
            class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You can only maximize positive magic"); 
          } else {
            class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "Current weapon is not magic"); 
          }
        }
        // Give the player a refund
        PRI = PC.PlayerReplicationInfo;
        if (PRI != None) {
          BD = class'BattleStaticFunctions'.static.ReadBPRI (PRI);
          BD.Mana = BD.Mana + ManaUsage;
          class'BattleStaticFunctions'.static.WriteBPRI (PRI, BD);
        }
      }
    }
  }
}


defaultproperties
{
  ArtifactName = "Max Magic";
  ManaUsage = 125;
}