/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleArtifactDraining extends BattleArtifact config (BattleRPG);

var config int ManaUsagePerSecond;

function StartDrainingArtifact (UTPawn P);
function StopDrainingArtifact (UTPawn P, bool bSilent);
function DamageToOtherPawn (UTPawn P, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType);
function ServerTimer (UTPawn P); // once per second
function RapidServerTimer (UTPawn P);  // 10 times per second

function string ArtifactCostDescription ()
{
  return ManaUsagePerSecond@"Mana/s";
}

defaultproperties
{
  ArtifactName = "Mana Draining Artifact";
  ManaUsagePerSecond = 5;
}