/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_LoadedWeapons extends BattleAbility config (BattleRPG);

function ServerModifyPlayer (UTPawn P, int Level)
{
  local array< class<Inventory> > BonusInventory;
  local int i;

  if (Level==1) {
    BonusInventory.Length = 4;
    BonusInventory[0] = Class'BattleRPG.BattleWeapon_Enforcer';
    BonusInventory[1] = Class'BattleRPG.BattleWeapon_ImpactHammer';
    BonusInventory[2] = Class'BattleRPG.BattleWeapon_Avril';
    BonusInventory[3] = Class'BattleRPG.BattleWeapon_BioRifle';
  } else if (Level==2) {
    BonusInventory.Length = 7;
    BonusInventory[0] = Class'BattleRPG.BattleWeapon_Enforcer';
    BonusInventory[1] = Class'BattleRPG.BattleWeapon_ImpactHammer';
    BonusInventory[2] = Class'BattleRPG.BattleWeapon_RocketLauncher';
    BonusInventory[3] = Class'BattleRPG.BattleWeapon_Avril';
    BonusInventory[4] = Class'BattleRPG.BattleWeapon_BioRifle';
    BonusInventory[5] = Class'BattleRPG.BattleWeapon_LinkGun';
    BonusInventory[6] = Class'BattleRPG.BattleWeapon_ShockRifle';
  } else if (Level==3) {
    BonusInventory.Length = 10;
    BonusInventory[0] = Class'BattleRPG.BattleWeapon_Enforcer';
    BonusInventory[1] = Class'BattleRPG.BattleWeapon_ImpactHammer';
    BonusInventory[2] = Class'BattleRPG.BattleWeapon_RocketLauncher';
    BonusInventory[3] = Class'BattleRPG.BattleWeapon_Avril';
    BonusInventory[4] = Class'BattleRPG.BattleWeapon_BioRifle';
    BonusInventory[5] = Class'BattleRPG.BattleWeapon_FlakCannon';
    BonusInventory[6] = Class'BattleRPG.BattleWeapon_LinkGun';
    BonusInventory[7] = Class'BattleRPG.BattleWeapon_ShockRifle';
    BonusInventory[8] = Class'BattleRPG.BattleWeapon_SniperRifle';
    BonusInventory[9] = Class'BattleRPG.BattleWeapon_Stinger';
  }
  for (i=0; i<BonusInventory.Length; i++) {
    if (P.FindInventoryType(BonusInventory[i]) == None) {
      P.CreateInventory(BonusInventory[i], true); // Do not select it, to prevent problems with weapon resurrection
    }
  } 
}

defaultproperties
{
  AbilityName = "Loaded Weapons";
  AbilityDescription = "Level 1 gives you the Avril and the Bio Rifle when you spawn. With level 2 you also get the Rocket Launcher, the Link Gun and the Shock Rifle. With Level 3 you get all weapons.";
  AbilityMaxLevel = 3;
  AbilityLevel1Cost = 10;
  AbilityCostIncreasePerLevel = 10;
}